/*
 * Decompiled with CFR 0.152.
 */
package memory.ihm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;
import memory.om.DosCarte;
import memory.om.Jeu;
import memory.om.Reponse;

public class MemoryFenetre
extends JDialog
implements ActionListener {
    private ArrayList<JButton> buttons;
    private int nbCases;
    private JButton newPartie;
    private int modeJeu;
    private Jeu game;
    private JButton firstCard;
    private int nbCoups = 0;
    private JLabel labelNbCoups;
    private JLabel labelScore;
    private int scoreTotal = 0;
    private int score1 = 0;
    private int score2 = 0;
    private boolean freezeMode;
    private boolean triche;
    private boolean jeuDuo;
    private int indexDos;
    private JPanel duoPanel;
    private boolean tourJ1;
    private JLabel labelScore1;
    private JLabel labelScore2;
    private JLabel labelSituationJoueur;

    MemoryFenetre(boolean pIsTricheOn, boolean pDuo, int pModeJeu, int pNbCartes, int pIndexDosCarte) {
        this.setTitle("Memory");
        this.setDefaultCloseOperation(2);
        JPanel contentPanel = new JPanel(new BorderLayout());
        JPanel grillePanel = new JPanel();
        JPanel subBarPanel = new JPanel(new BorderLayout());
        JPanel scorePanel = new JPanel();
        this.duoPanel = new JPanel(new BorderLayout());
        JPanel scoreDuoPanel = new JPanel(new GridLayout(2, 1));
        this.nbCases = pNbCartes;
        this.triche = pIsTricheOn;
        this.modeJeu = pModeJeu;
        this.indexDos = pIndexDosCarte;
        this.jeuDuo = pDuo;
        this.add(contentPanel);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)grillePanel, "Center");
        contentPanel.add((Component)subBarPanel, "South");
        grillePanel.setLayout(new GridLayout((int)Math.sqrt(this.nbCases), (int)Math.sqrt(this.nbCases), 5, 5));
        grillePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menuJeu = new JMenu("Jeu");
        menuBar.add(menuJeu);
        JMenu menuAide = new JMenu("?");
        menuBar.add(menuAide);
        JMenuItem itemNewGame = new JMenuItem("Nouvelle partie");
        itemNewGame.setActionCommand("newGame");
        itemNewGame.addActionListener(this);
        menuJeu.add(itemNewGame);
        JMenuItem itemQuit = new JMenuItem("Quitter");
        itemQuit.setActionCommand("quitter");
        itemQuit.addActionListener(this);
        menuJeu.add(itemQuit);
        JMenuItem itemInfo = new JMenuItem("Info");
        itemInfo.setActionCommand("info");
        itemInfo.addActionListener(this);
        menuAide.add(itemInfo);
        this.buttons = new ArrayList();
        Color couleurBouton = new Color(250, 250, 250);
        int i = 0;
        while (i < this.nbCases) {
            this.buttons.add(new JButton());
            this.buttons.get(i).setPreferredSize(new Dimension(100, 150));
            this.buttons.get(i).setBackground(couleurBouton);
            this.buttons.get(i).setIcon(new ImageIcon(this.getClass().getResource("/memory/ihm/img/" + (Object)((Object)DosCarte.values()[this.indexDos]) + ".png")));
            this.buttons.get(i).addActionListener(this);
            grillePanel.add(this.buttons.get(i));
            ++i;
        }
        subBarPanel.setPreferredSize(new Dimension(300, 80));
        subBarPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 25, 5));
        this.labelNbCoups = new JLabel("Coups jou\u00e9s : " + this.nbCoups);
        this.labelScore = new JLabel("Score total : " + this.scoreTotal);
        this.newPartie = new JButton("Nouvelle Partie");
        this.newPartie.setPreferredSize(new Dimension(150, 20));
        this.newPartie.setBackground(new Color(250, 250, 250));
        subBarPanel.add((Component)this.labelNbCoups, "West");
        subBarPanel.add((Component)this.newPartie, "East");
        subBarPanel.add((Component)scorePanel, "South");
        scorePanel.add(this.labelScore);
        this.newPartie.addActionListener(this);
        this.newPartie.setActionCommand("newGame");
        if (this.jeuDuo) {
            contentPanel.add((Component)this.duoPanel, "West");
            this.duoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 0, 240), 2, true), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            this.labelScore1 = new JLabel("Score du joueur 1 : " + this.score1);
            this.labelScore2 = new JLabel("Score du joueur 2 : " + this.score2);
            this.labelScore1.setForeground(new Color(0, 0, 240));
            this.labelScore2.setForeground(new Color(240, 0, 0));
            this.labelScore1.setFont(new Font("SansSerif", 1, 14));
            this.labelScore2.setFont(new Font("SansSerif", 1, 14));
            scoreDuoPanel.add(this.labelScore1);
            scoreDuoPanel.add(this.labelScore2);
            this.labelSituationJoueur = new JLabel("Tour du joueur 1");
            this.labelSituationJoueur.setForeground(new Color(0, 0, 240));
            this.labelSituationJoueur.setFont(new Font("SansSerif", 1, 20));
            this.duoPanel.add((Component)scoreDuoPanel, "West");
            this.duoPanel.add((Component)this.labelSituationJoueur, "Center");
            this.tourJ1 = true;
        }
        this.game = new Jeu(this.nbCases / 2, pIsTricheOn);
        this.setModal(true);
        this.setResizable(false);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.freezeMode) {
            return;
        }
        switch (event.getActionCommand()) {
            case "newGame": {
                this.dispose();
                MemoryFenetre newG = new MemoryFenetre(this.triche, this.jeuDuo, this.modeJeu, this.nbCases, this.indexDos);
                newG.setVisible(true);
                break;
            }
            case "info": {
                JOptionPane.showMessageDialog(this, "<html><h1>Memory</h1><br/><br/>Cyril ROUMEGOUS - 2019</html>", "Memory", 1);
                break;
            }
            case "quitter": {
                this.dispose();
            }
        }
        if (event.getSource() instanceof JButton) {
            final JButton caseChoisie = (JButton)event.getSource();
            int index = this.buttons.indexOf(caseChoisie);
            Reponse rep = this.game.jouer(index);
            int val = 0;
            System.out.println(index);
            if (index >= 0) {
                val = this.game.getCarteValeur(index);
            }
            if (rep != Reponse.ERREUR) {
                if (rep == Reponse.GAGNE) {
                    caseChoisie.setIcon(this.getIcon(val));
                    ++this.scoreTotal;
                    this.labelScore.setText("Score total : " + this.scoreTotal);
                    if (this.jeuDuo) {
                        if (this.tourJ1) {
                            ++this.score1;
                            this.labelScore1.setText("Score du joueur 1 : " + this.score1);
                        } else {
                            ++this.score2;
                            this.labelScore2.setText("Score du joueur 2 : " + this.score2);
                        }
                    }
                    if (this.game.isPartieTerminee()) {
                        this.afficherFinPartie();
                    }
                } else if (rep == Reponse.PREMIERE) {
                    caseChoisie.setIcon(this.getIcon(val));
                    this.firstCard = caseChoisie;
                } else if (rep == Reponse.PERDU) {
                    caseChoisie.setIcon(this.getIcon(val));
                    this.freezeMode = true;
                    Timer timer = new Timer(1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            caseChoisie.setIcon(new ImageIcon(this.getClass().getResource("/memory/ihm/img/" + (Object)((Object)DosCarte.values()[MemoryFenetre.this.indexDos]) + ".png")));
                            MemoryFenetre.this.firstCard.setIcon(new ImageIcon(this.getClass().getResource("/memory/ihm/img/" + (Object)((Object)DosCarte.values()[MemoryFenetre.this.indexDos]) + ".png")));
                            MemoryFenetre.this.freezeMode = false;
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                    this.changerTour();
                }
            }
            this.nbCoups = this.game.getNbCoupsJoues();
            this.labelNbCoups.setText("Coups jou\u00e9s : " + this.nbCoups);
        }
    }

    public ImageIcon getIcon(int val) {
        switch (this.modeJeu) {
            case 0: {
                return new ImageIcon(this.getClass().getResource("/memory/ihm/img/nombre/" + val + ".png"));
            }
            case 1: {
                return new ImageIcon(this.getClass().getResource("/memory/ihm/img/couleur/" + val + ".png"));
            }
            case 2: {
                return new ImageIcon(this.getClass().getResource("/memory/ihm/img/lettres/" + val + ".png"));
            }
            case 3: {
                return new ImageIcon(this.getClass().getResource("/memory/ihm/img/mahjong/" + val + ".png"));
            }
            case 4: {
                return new ImageIcon(this.getClass().getResource("/memory/ihm/img/dbz/" + val + ".png"));
            }
        }
        return null;
    }

    public void changerTour() {
        if (this.jeuDuo) {
            if (this.tourJ1) {
                this.tourJ1 = false;
                this.labelSituationJoueur.setText("Tour du joueur 2");
                this.duoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(240, 0, 0), 2, true), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
                this.labelSituationJoueur.setForeground(new Color(240, 0, 0));
            } else {
                this.tourJ1 = true;
                this.labelSituationJoueur.setText("Tour du joueur 1");
                this.duoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(0, 0, 240), 2, true), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
                this.labelSituationJoueur.setForeground(new Color(0, 0, 240));
            }
        }
    }

    public void afficherFinPartie() {
        if (this.jeuDuo) {
            if (this.score1 > this.score2) {
                JOptionPane.showMessageDialog(this, "Partie termin\u00e9e\nVictoire du Joueur 1");
            } else if (this.score1 == this.score2) {
                JOptionPane.showMessageDialog(this, "Partie termin\u00e9e\n\u00c9galit\u00e9");
            } else {
                JOptionPane.showMessageDialog(this, "Partie termin\u00e9e\nVictoire du Joueur 2");
            }
        } else {
            JOptionPane.showMessageDialog(this, "Partie termin\u00e9e");
        }
        this.newPartie.setBackground(new Color(0, 250, 0));
    }
}

