/*
 * Decompiled with CFR 0.152.
 */
package memory.ihm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import memory.ihm.MemoryFenetre;

public class MemoryLauncher
extends JFrame
implements ActionListener {
    private JButton newGame;
    private JComboBox<String> choixtypeCarteCB;
    private JComboBox<String> choixNbCartesCB;
    private JComboBox<String> choixDosCartesCB;
    private JRadioButton radioUn = new JRadioButton("Un");
    private JRadioButton radioDeux = new JRadioButton("Deux");
    private JRadioButton radioNormal = new JRadioButton("Normal");
    private JRadioButton radioTriche = new JRadioButton("Triche");

    MemoryLauncher() {
        super("Memory");
        this.setDefaultCloseOperation(3);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setPreferredSize(new Dimension(500, 450));
        this.add(contentPanel);
        JLabel titre = new JLabel("<html><h1>MEMORY</h1></html>");
        JLabel labelNbCartes = new JLabel("Nombres de cartes : ");
        JLabel labelDosCarte = new JLabel("Dos de carte : ");
        JLabel labelNbJoueur = new JLabel("Nombre de Joueur :");
        JPanel configPanel = new JPanel(new GridLayout(7, 2, 10, 10));
        JPanel northPanel = new JPanel(new GridBagLayout());
        JPanel southPanel = new JPanel(new GridBagLayout());
        String[] choixCarte = new String[]{"Nombre", "Couleur", "Lettres", "Mahjong", "DBZ"};
        String[] choixNbCartes = new String[]{"24", "16", "10", "4"};
        String[] choixDosCartes = new String[]{"Classique", "Hearthstone", "Pokemon", "Yugioh", "Bicycle", "DBZ"};
        this.choixNbCartesCB = new JComboBox<String>(choixNbCartes);
        this.choixtypeCarteCB = new JComboBox<String>(choixCarte);
        this.choixDosCartesCB = new JComboBox<String>(choixDosCartes);
        ButtonGroup grpNbJoueur = new ButtonGroup();
        grpNbJoueur.add(this.radioUn);
        grpNbJoueur.add(this.radioDeux);
        ButtonGroup grpModeJeu = new ButtonGroup();
        grpModeJeu.add(this.radioNormal);
        grpModeJeu.add(this.radioTriche);
        contentPanel.add((Component)northPanel, "North");
        contentPanel.add((Component)configPanel, "Center");
        contentPanel.add((Component)southPanel, "South");
        configPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        configPanel.add(labelNbCartes);
        configPanel.add(this.choixNbCartesCB);
        configPanel.add(labelDosCarte);
        configPanel.add(this.choixDosCartesCB);
        configPanel.add(labelNbJoueur);
        configPanel.add(this.radioUn);
        configPanel.add(new JLabel(""));
        configPanel.add(this.radioDeux);
        configPanel.add(new JLabel("Type de carte : "));
        configPanel.add(this.choixtypeCarteCB);
        configPanel.add(new JLabel("Mode de jeu : "));
        configPanel.add(this.radioNormal);
        configPanel.add(new JLabel(""));
        configPanel.add(this.radioTriche);
        this.radioUn.setSelected(true);
        this.radioNormal.setSelected(true);
        northPanel.add(titre);
        titre.setForeground(new Color(0, 220, 0));
        this.newGame = new JButton("Nouvelle partie");
        this.newGame.setBackground(new Color(0, 250, 0));
        southPanel.add(this.newGame);
        southPanel.setBorder(new EmptyBorder(30, 10, 30, 10));
        this.newGame.addActionListener(this);
        this.choixtypeCarteCB.addActionListener(this);
        this.choixNbCartesCB.addActionListener(this);
        this.choixDosCartesCB.addActionListener(this);
        this.setResizable(false);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newGame) {
            int typeCarte = this.choixtypeCarteCB.getSelectedIndex();
            int nbCartes = Integer.parseInt(this.choixNbCartesCB.getSelectedItem().toString());
            boolean jeuEnDuo = this.radioDeux.isSelected();
            boolean jeuTriche = this.radioTriche.isSelected();
            MemoryFenetre memory = new MemoryFenetre(jeuTriche, jeuEnDuo, typeCarte, nbCartes, this.choixDosCartesCB.getSelectedIndex());
            memory.setVisible(true);
        }
    }
}

