/*
 * Decompiled with CFR 0.152.
 */
package memory.om;

import java.util.ArrayList;
import java.util.Collections;
import memory.om.Carte;
import memory.om.Reponse;

public class Jeu {
    private int nbPaires;
    private int nbPairesTrouvees = 0;
    private int nbCoupsJoues = 0;
    private ArrayList<Carte> cartes;
    private Carte premiereCarte = null;

    public Jeu(int nbPaires) {
        this(nbPaires, false);
    }

    public Jeu(int nbPaires, boolean modeTriche) {
        this.nbPaires = nbPaires;
        this.cartes = new ArrayList();
        int i = 0;
        while (i < this.nbPaires) {
            this.cartes.add(new Carte(i));
            this.cartes.add(new Carte(i));
            ++i;
        }
        if (!modeTriche) {
            Collections.shuffle(this.cartes);
        }
    }

    public Reponse jouer(int numCarte) {
        if (numCarte < 0 || numCarte >= this.nbPaires * 2) {
            System.out.println("ERR: numinvalide");
            return Reponse.ERREUR;
        }
        Carte carteChoisie = this.cartes.get(numCarte);
        if (carteChoisie.isTrouvee()) {
            System.out.println("ERR: carte deja trouv\u00e9e");
            return Reponse.ERREUR;
        }
        if (this.premiereCarte == carteChoisie) {
            System.out.println("ERR: carte deja choisie");
            return Reponse.ERREUR;
        }
        ++this.nbCoupsJoues;
        if (this.premiereCarte == null) {
            this.premiereCarte = carteChoisie;
            return Reponse.PREMIERE;
        }
        if (this.premiereCarte.equals(carteChoisie)) {
            this.premiereCarte.setTrouvee(true);
            carteChoisie.setTrouvee(true);
            this.premiereCarte = null;
            ++this.nbPairesTrouvees;
            return Reponse.GAGNE;
        }
        this.premiereCarte = null;
        return Reponse.PERDU;
    }

    public int getCarteValeur(int numCarte) {
        return this.cartes.get(numCarte).getValeur();
    }

    public boolean isCarteTrouvee(int numCarte) {
        return this.cartes.get(numCarte).isTrouvee();
    }

    public boolean isPartieTerminee() {
        return this.nbPairesTrouvees >= this.nbPaires;
    }

    public int getNbPaires() {
        return this.nbPaires;
    }

    public int getNbCartes() {
        return this.nbPaires * 2;
    }

    public int getNbPairesTrouvees() {
        return this.nbPairesTrouvees;
    }

    public int getNbCartesTrouvees() {
        return this.nbPairesTrouvees * 2;
    }

    public int getNbCoupsJoues() {
        return this.nbCoupsJoues;
    }
}

